/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.googles;

import frc.emul.periph.IPeripheral;
import frc.emul.periph.misc.AbstractDevice;
import frc.emul.vectrex.Vectrex;
import java.awt.Component;

public class Goggles
extends AbstractDevice
implements IPeripheral.TickHandler,
IPeripheral.WriteHandler {
    public static final boolean TRACE = false;
    public static final String NAME = "3D Goggles";
    int last = 0;
    long stamp = 0L;
    private static final int DATA_INPUT = 4;
    private static final int DATA_OUTPUT = 8;
    private static final float OUT_PERIOD = 0.0375f;
    private static final float OUT_PULSE = 0.014f;
    private static final int CYCLES_PERIOD = 60000;
    private static final int CYCLES_PULSE = 22400;
    private boolean inHigh = true;
    private boolean outHigh = true;
    private int countDown;

    public String getID() {
        return "3D-GOGGLES";
    }

    public String getName() {
        return NAME;
    }

    public void plug(Component component, int n) {
    }

    public void unplug(Component component, int n) {
    }

    public int getButtonsState() {
        return this.outHigh ? 15 : 0;
    }

    public void handleWrite(int n, int n2) {
        if (14 != n) {
            return;
        }
        if (this.last != n2) {
            long l;
            boolean bl = this.inHigh = (n2 & 0x40) != 0;
            if (!this.inHigh) {
                this.outHigh = false;
                this.countDown = 22400;
            }
            this.last = n2;
            this.stamp = l = Vectrex.INSTANCE.getCPU().getCycles();
        }
    }

    public final void handleTick(int n) {
        if ((this.countDown -= n) <= 0) {
            this.switchData();
            this.countDown = this.outHigh ? (this.countDown += 37600) : (this.countDown += 22400);
        }
    }

    public void reset() {
        this.inHigh = true;
        this.outHigh = true;
        this.countDown = 0;
    }

    private final void switchData() {
        this.outHigh = !this.outHigh;
    }
}

